//===============================================================================
// Microsoft patterns & practices Enterprise Library
// Configuration Application Block
//===============================================================================
// Copyright  Microsoft Corporation.  All rights reserved.
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY
// OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT
// LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE.
//===============================================================================

using Microsoft.Practices.EnterpriseLibrary.Configuration.Factory;
using System;

namespace Microsoft.Practices.EnterpriseLibrary.Configuration.Injection
{
	/// <summary>
	/// Represents a strategy for transforming a nameed refernece into the object that it represents.
	/// </summary>
    public class ReferenceFactory<TObjectToCreate, TObjectConfiguration> : ObjectFactoryBase<TObjectToCreate, TObjectConfiguration>
	{
        private readonly IObjectFactory<TObjectToCreate, TObjectConfiguration> factory;

		/// <summary>
		/// Initialize a new instance of the <see cref="ReferenceFactory"/> class with a factory to create the value and if the value is required.
		/// </summary>
		/// <param name="factory">An <see cref="INamedObjectFactory"/> object.</param>
		/// <param name="required"><see langword="true"/> if the value is required; otherwise, <see langword="false"/>.</param>
        public ReferenceFactory(IObjectFactory<TObjectToCreate, TObjectConfiguration> factory)
		{
			if (factory == null)
			{
				throw new ArgumentNullException("factory");
			}		

			this.factory = factory;
		}

		/// <summary>
		/// Gets the factory used to create the object.
		/// </summary>
		/// <value>
		/// The factory used to create the object.
		/// </value>
        public IObjectFactory<TObjectToCreate, TObjectConfiguration> Factory
		{
			get { return factory; }
		}

        public override TObjectToCreate Create(TObjectConfiguration objectConfiguration, IConfigurationSource configurationSource)
        {
            if (Object.Equals(objectConfiguration, default(TObjectConfiguration)))
            {
                return default(TObjectToCreate);
            }

            return this.factory.Create(objectConfiguration, configurationSource);
        }
    }
}
